package com.digiwin.athena.semc.common;

/**
 * @Author: sunyfa
 * @CreateTime: 2022/12/22 16:24
 * @Description: I18N key
 * @Version: 1.0
 */
public final class I18NKey {
    private I18NKey(){}

    // 系统异常
    public static final String SYSTEM_ERROR = "system.exception.api.fail";

    // 系统异常，请联系管理员
    public static final String COMMON_SYSTEM_ERROR = "error.message.common.system-error";

    // 系统异常完善信息
    public static final String COMMON_SYSTEM_ERROR_FULL = "error.message.common.full.system-error";

    // 请检查参数的合法性
    public static final String COMMON_PARAM_ILLEGAL = "error.message.common.param-illegal";

    // 缺少必要参数
    public static final String COMMON_PARAM_MISSING = "error.message.common.param-missing";

    public static final String COMMON_PARAM_LENGTH = "error.message.common.param-length";

    public static final String COMMON_PARAM_IP = "error.message.common.ip";

    // 更新异常，请联系管理员
    public static final String COMMON_UPDATE_ERROR = "error.message.common.update-error";

    public static final String TODO_OPEN_ERROR = "error.message.todo.open-error";

    public static final String TODO_FIELD_MISSING_ERROR = "error.message.todo.field-missing-error";

    public static final String NEWS_OPEN_ERROR = "error.message.news.open-error";

    public static final String REPORT_OPEN_ERROR = "error.message.report.open-error";

    /**
     * 未查询到应用配置信息
     */
    public static final String QUERY_NOT_FOUND = "error.message.query.not-found";

    /**
     * 查询应用配置信息失败
     */
    public static final String QUERY_OCCUR_ERROR = "error.message.query.error";

    // 操作失败，您选择的数据含有生效数据，请先置为失效状态再做操作
    public static final String BIND_MODE_IN_EFFECT = "error.message.bindMode.in.effect";

    // 您设置的应用含有非雅典娜SSO规范的应用，该类应用只能是手动归户模式
    public static final String CONTAIN_SPECIAL_APPLICATION = "error.message.contain.special.application";

    // 动态参数格式不正确,格式样例：{'key':'value'}
    public static final String DYNAMIC_PARAM_ILLEGAL = "error.message.dynamic.param.illegal";

    // 应用名称或appToken已存在
    public static final String DATA_REPEAT = "error.message.data.repeat";

    // 应用code已存在
    public static final String APP_CODE_REPEAT = "error.message.appcode.repeat";
    // 应用名称已存在
    public static final String APP_NAME_REPEAT = "error.message.appname.repeat";
    // 应用token已存在
    public static final String APP_TOKEN_REPEAT = "error.message.apptoken.repeat";
    //回调地址比传
    public static final String APP_CALL_BACK_NOT_EMPTY ="error.message.web.or.mobile.callback.not.empty";
    // 应用code在b/s配置中已存在
    public static final String BS_APP_CODE_REPEAT = "error.message.bs.appcode.repeat";
    // 应用名称在b/s配置中已存在
    public static final String BS_APP_NAME_REPEAT = "error.message.bs.appname.repeat";
    // 应用token在b/s配置中已存在
    public static final String BS_APP_TOKEN_REPEAT = "error.message.bs.apptoken.repeat";

    // 应用code在c/s配置中已存在
    public static final String CS_APP_CODE_REPEAT = "error.message.cs.appcode.repeat";
    // 应用名称在c/s配置中已存在
    public static final String CS_APP_NAME_REPEAT = "error.message.cs.appname.repeat";
    // 应用token在c/s配置中已存在
    public static final String CS_APP_TOKEN_REPEAT = "error.message.cs.apptoken.repeat";
    // 该配置是生效状态, 不能修改
    public static final String APP_CODE_CHANGE = "error.message.appCode.change";

    // 预设应用配置中已存在
    public static final String PRE_APP_NAME_REPEAT = "error.message.pre.appname.repeat";

    // 查询不到应用信息
    public static final String APP_QUERY_NOT_FOUND = "error.message.app.query.not.found";

    // 该配置是生效状态, 不能修改
    public static final String CONFIG_IN_EFFECT = "error.message.config.in.effect";

    // 调用IAM更新应用失败
    public static final String INVOKE_IAM_ERROR = "error.message.invoke.iam.error";

    // 保存应用配置失败
    public static final String SAVE_APP_ERROR = "error.message.save.app.error";

    // 报表名称已经存在
    public static final String FINE_REPORT_NAME_EXISTS = "error.message.fineReport.name.exists";
    // 报表链接已经存在
    public static final String FINE_REPORT_LINK_EXISTS = "error.message.fineReport.url.exists";
    // 源目录和目标目录不能相同
    public static final String FINE_REPORT_FOLDER = "error.message.fineReport.folder";

    // 当前目录存在子目录，不能在此目录上新增数据
    public static final String FOLDER_CHILD_NODE_EXISTS = "error.message.folder.child.exists";
    // 目录名称已存在
    public static final String FOLDER_NAME_EXISTS = "error.message.folder.name.exists";
    // 目录层级为%s，不能增加子目录
    public static final String FOLDER_CHILD_NODE_ADD_LEVEL = "error.message.folder.child.add.level";
    // 父目录存在数据，不能增加子目录
    public static final String FOLDER_CHILD_NODE_ADD_DATA = "error.message.folder.child.add.data";
    // 当前目录存在数据，不能移动其他目录到此目录下
    public static final String FOLDER_CHILD_NODE_MOVE_DATA = "error.message.folder.child.move.data";
    // 父目录不存在
    public static final String FOLDER_ROOT_NON_EXISTS = "error.message.folder.root.non.exists";
    // 目录不存在
    public static final String FOLDER_NON_EXISTS = "error.message.folder.non.exists";
    // 最少要有一个父目录，不允许将一级目录全部删除
    public static final String FOLDER_ROOT_DELETE = "error.message.folder.root.delete";
    // 目录层级不能为空
    public static final String FOLDER_LEVEL_NOT_EXISTS = "error.message.folder.level.not.exists";
    // 目录层级不正确
    public static final String FOLDER_LEVEL_RANGE_ERROR = "error.message.folder.not.same";

    // 预设组件查询失败
    public static final String SYSTEM_PRE = "error.message.system.pre.open-error";

    // 更新数据源
    public static final String DATASOURCE = "error.message.data.source.update-error";

    // 更新启用停用状态
    public static final String VALID_STATUS = "error.message.valid.status.update-error";

    // 自定义组件查询失败
    public static final String SYSTEM_CUSTOM = "error.message.system.custom.open-error";

    // 自定义组件保存失败
    public static final String SAVE_SYSTEM_CUSTOM = "error.message.system.custom.save-error";

    // 自定义组件编辑失败
    public static final String UPDATE_SYSTEM_CUSTOM = "error.message.system.custom.update-error";

    // 自定义组件删除失败
    public static final String DELETE_SYSTEM_CUSTOM = "error.message.system.custom.delete-error";

    public static final String SAVE_PORTAL_LAYOUT = "error.message.portal.layout.save-error";
    //门户不存在
    public static  final String PORTAL_NOT_EXIST = "error.message.portal.not.exist.error";
    //门户未发布
    public static final String PORTAL_NOT_PUBLISH ="error.message.portal.not.publish.error";

    public static final String DELETE_PORTAL_LAYOUT = "error.message.portal.layout.delete-error";

    // 用户已存在白名单
    public static final String WHITE_USER_IS_EXIST = "error.message.white.user.exist";
    // 用户已存在黑名单
    public static final String BLACK_USER_IS_EXIST = "error.message.black.user.exist";

    // 获取授权出现异常
    public static final String IAM_AUTHORIZE_EXCEPTION = "error.message.iam.authorize.exception";

    // 菜单数量超过上限
    public static final String MENU_TEMPLATE_COUNT_OVER_LIMIT = "error.message.template.count.over";
    // 菜单模板名称重复
    public static final String MENU_TEMPLATE_NAME_DUPLICATE = "error.message.template.name.duplicate";
    // 菜单模板未配置权限
    public static final String MENU_TEMPLATE_NOT_AUTH = "error.message.template.not.auth";
    // 单个菜单模板状态不能取消发布的文案
    public static final String MENU_TEMPLATE_NOT_CANCEL = "error.message.template.not.cancel";
    // 批量菜单模板状态不能取消发布的文案
    public static final String MENU_TEMPLATE_NOT_CANCEL_BATCH = "error.message.template.not.cancel.batch";
    // 单个菜单模板状态不能删除的文案
    public static final String MENU_TEMPLATE_NOT_DELETE = "error.message.template.not.delete";
    // 批量菜单模板状态不能删除的文案
    public static final String MENU_TEMPLATE_NOT_DELETE_BATCH = "error.message.template.not.delete.batch";
    // 用户组件权限导入不能为空
    public static final String USER_LABEL_IMPORT_NOT_EMPTY = "error.message.user.label.import.not.empty";
    //菜单名称不能为空
    public static final String MENU_NAME_CANNOT_BE_NULL = "error.message.menu.name.cannot.be.null";

    public static final String MIDDLE_SYSTEM_PARAM_MISSING = "error.message.middle.system.param.missing";

    public static final String PORTAL_NOT_AUTH ="error.message.not.auth" ;

    public static final String MOBILE_PORTAL_CUSTOM_DEL ="error.message.mobile.portal.custom.del" ;

    //appCode丢失
    public static final String USER_MAPPING_APPCODE_MISSING = "error.message.user.mapping.appcode.missing";

    //移动作业无权限提示
    public static final String MOBILE_WORK_NOT_AUTH ="error.message.mobile.work.not.auth" ;

    //所有工作提醒已标记为已读提示
    public static final String MESSAGE_MSG_READ ="message.msg.read" ;

    //暂无未读工作提醒提示
    public static final String MESSAGE_MSG_NO_READ ="message.msg.no.read" ;


}
