package com.digiwin.athena.semc.common;

/**
 * 新闻公告类型 常量
 *
 * @author sungqz
 * @since 2025-1-13
 */
public interface NewsTypeConstants {

    /**
     * 一级公告类型的父级id
     */
    Long NEWS_TYPE_FIRST_LEVEL_PARENT_ID = 0L;

    /**
     * 一级公告类型层级
     */
    Integer NEWS_TYPE_FIRST_LEVEL = 1;

    /**
     * 二级公告类型层级
     */
    Integer NEWS_TYPE_SECOND_LEVEL = 2;

    /**
     * 公告类型数量上限
     */
    Integer MAX_NEWS_TYPE_COUNT = 30;

    /**
     * 公告类型 其他
     */
    Long NEWS_TYPE_OTHER_ID = 4L;

    /**
     * 默认公告类型标识
     */
    Integer NEWS_TYPE_DEFAULT_FLAG = 1;

    /**
     * "其他"公告类型
     */
    String OTHER_NEWS_TYPE_NAME = "其他";

    /**
     * 校验通过
     */
    String NEWS_TYPE_VALID_SUCCESS = "1000";

    /**
     * 公告类型不存在，请重新选择
     */
    String CURRENT_NOT_EXIST = "1001";

    /**
     * 当前公告类型已经包含子级，仅可作为一级类型
     */
    String CONTAINS_CHILD = "1002";

    /**
     * 一级公告类型不能超过30个
     */
    String FIRST_MAX_COUNT = "1003";

    /**
     * 所属父级类型不存在
     */
    String PARENT_NOT_EXIST = "1004";

    /**
     * 所属父级类型不能包含公告
     */
    String PARENT_CONTAINS_NEWS = "1005";

    /**
     * 所属父级下的二级公告类型不能超过30个
     */
    String SECOND_MAX_COUNT = "1006";

    /**
     * 当前公告类型包含数据，不可添加子级
     */
    String CURRENT_CONTAINS_NEWS = "1007";

    /**
     * 当前公告类型的子级已达上限
     */
    String CURRENT_CHILD_MAX_COUNT = "1008";

    /**
     * 当前公告的所属类型无权操作，请刷新后再试
     */
    String CURRENT_SINGLE_WITHOUT_PERMISSION = "1009";

    /**
     * 所选公告的所属类型，部分无权操作，请刷新后再试
     */
    String CURRENT_BATCH_WITHOUT_PERMISSION = "1010";

    /**
     * 不可选择一级公告类型，请重新选择
     */
    String CHANGE_TO_FIRST = "1011";

    /**
     * 公告类型无权限，请重新选择
     */
    String CURRENT_WITHOUT_PERMISSION = "1012";

    /**
     * 当前一级公告类型已包含二级类型，请重新选择
     */
    String FIRST_CONTAINS_SECOND = "1013";
}
