package com.digiwin.athena.semc.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ParamBean<T> implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    private Integer pageIndex = 0;

    private Integer pageSize = 100;

    private String sortField;

    private String sortType = "asc";

    private Map<String, Object> q;

    private T value;

    private String sequence;


    public ParamBean() {
    }

    public ParamBean(boolean unique) {
        if (unique) {
            this.sequence = UUID.randomUUID().toString();
        }
    }


    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        if (pageSize != null && pageSize < 1) {
            return 1;
        }
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }


    public String getSortField() {
        return sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public Map<String, Object> getQ() {
        if (null == q) {
            q = new HashMap<>();
        }
        return q;
    }

    public void setQ(Map<String, Object> q) {
        this.q = q;
    }

    public T getValue() {
        return value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getSequence() {
        return sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    @Override
    public String toString() {
        return "ParamBean [pageIndex=" + pageIndex + ", pageSize=" + pageSize + ", sortField=" + sortField
                + ", sortType=" + sortType + ", q=" + q + ", value=" + value + ", sequence=" + sequence + "]";
    }
}
