package com.digiwin.athena.semc.common;

import com.digiwin.athena.semc.dto.PageInfo;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author: sunyfa
 * @CreateTime: 2022/12/10 13:49
 * @Description: 分页返回对象集合
 * @Version: 1.0
 */
@Data
public class ResponseBody implements Serializable {
    private static final long serialVersionUID = 4202061123968591901L;

    // 数据对象
    private Object data;

    // 分页信息
    private PageInfo pageInfo;

    private ResponseBody(Object data, PageInfo pageInfo) {
        this.data = data;
        this.pageInfo = pageInfo;
    }

    public static ResponseBody getInstance(Object data, PageInfo pageInfo) {
        return new ResponseBody(data, pageInfo);
    }
}
