package com.digiwin.athena.semc.common;

import com.digiwin.athena.semc.common.enums.StatusEnum;
import lombok.Data;
import org.springframework.context.i18n.LocaleContextHolder;

import java.io.Serializable;
import java.util.Map;

/**
 * 分页返回包装类
 */
@Data
public class ResultPageBean implements Serializable {
    private static final long serialVersionUID = 2405172041950251807L;

    // 返回码，调用成功时返回200
    // 存在异常时放回对应的异常码，包含业务异常和系统异常
    // 取值 StatusEnum 枚举值
    private Integer status = 200;

    // 错误码，包含业务错误和系统错误
    private Integer errorCode;

    // 错误信息
    private String errorMessage;

    // 语言
    private String lang;

    // 返回体，包含数据和分页信息
    private ResponseBody response;

    // 扩展信息
    private Map<String, Object> ext;

    // 扩展token
    private String token;

    /**
     * 构造成功分页对象
     *
     * @param response 业务数据
     * @return 分页对象
     */
    public static ResultPageBean success(ResponseBody response) {
        return new ResultPageBean(null, null, StatusEnum.SUCCESS_STATUS.getStatusCode(), response,
                LocaleContextHolder.getLocale().toString());
    }

    /**
     * 构造业务异常分页对象
     *
     * @param bizException 业务异常
     * @return 分页对象
     */
    public static ResultPageBean bizException(BizException bizException) {
        return new ResultPageBean(bizException.getCode(), bizException.getMessage(),
                StatusEnum.BUSINESS_ERROR_STATUS.getStatusCode(), null, bizException.getLang());
    }

    /**
     * 构造系统异常分页对象
     *
     * @param sysException 系统异常
     * @return 分页对象
     */
    public static ResultPageBean sysException(ServiceException sysException) {
        return new ResultPageBean(sysException.getCode(), sysException.getMessage(),
                StatusEnum.SYSTEM_ERROR_STATUS.getStatusCode(), null, sysException.getLang());
    }

    private ResultPageBean(Integer errorCode, String errorMessage, Integer status, ResponseBody response, String lang) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.status = status;
        this.response = response;
        this.lang = lang;
    }
}
