package com.digiwin.athena.semc.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.baomidou.mybatisplus.annotation.IEnum;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @description: 应用类型枚举
 * @createDate: 2024-01-31
 * @author: sungqz
 */
public enum ApplicationTypeEnum {

    BS_APPLICATION(1), // BS表
    CS_APPLICATION(2), // CS表
    PRESET_APPLICATION(3), // 预设表
    IAM_APPLICATION(4), // IAM接口
    VIRTUAL_APPLICATION(5); // 虚拟应用

    @EnumValue
    @JsonValue // 标记响应json值
    private Integer type;

    ApplicationTypeEnum(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return type;
    }
}
