package com.digiwin.athena.semc.common.enums;

import lombok.Getter;

import java.util.Date;

/**
 * @author guijf
 */

@Getter
public enum AttributeDataTypeEnum {

    /**
     * int/varchar/text/datetime/boolean/decimal
     */
    VARCHAR(String.class,"短字符串"),

    TEXT(String.class,"长文本"),

    BOOLEAN(Boolean.class,"布尔"),

    INT(Integer.class,"整数"),

    DECIMAL(Double.class,"小数数字"),

    DATETIME(Date.class,"时间")
    ;
    private final Class<?> dataType;

    private final String desc;

    AttributeDataTypeEnum(Class<?> dataType, String desc) {
        this.dataType = dataType;
        this.desc = desc;
    }

    public static AttributeDataTypeEnum fromCode(String code) {
        for (AttributeDataTypeEnum type : values()) {
            if (type.name().equalsIgnoreCase(code)) {
                return type;
            }
        }
        return null; // 或抛出异常
    }

}
