package com.digiwin.athena.semc.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.baomidou.mybatisplus.annotation.IEnum;

/**
 * @description: 业务授权类型
 * @createDate: 2023/5/29 16:36
 * @author: sunyfa
 */
public enum BizAuthTypeEnum implements IEnum<Integer> {
    ORG(1),// 组织
    ROLE(2),// 角色
    USER(3),// 用户
    EXTERNAL_USER(4),// 外部用户
    DEPARTMENT(5);// 部门

    @EnumValue
    private Integer type;

    BizAuthTypeEnum(Integer type) {
        this.type = type;
    }

    @Override
    public Integer getValue() {
        return type;
    }
}
