package com.digiwin.athena.semc.common.enums;

/**
 * @Author: sunyfa
 * @CreateTime: 2022/12/8 19:09
 * @Description: 对接的系统服务名
 * @Version: 1.0
 */
public enum EAIServiceNameEnum {
    REPORT("report.info.get"),
    TODOLIST("to.do.list.get"),
    NEWS("news.get"),
    NOTICE("notice.get"),
    // 混合云模式B/S应用跳转
    BS_APP_REDIRECT("bs.app.redirect"),
    THIRD_JOB_QUERY("third.job.query"),
    //三方待办拉取服务名称
    TO_DO_LIST_QUERY("to.do.list.query"),
    //统计组件服务接口名称
    COUNT_COMPONENT_LIST("third.component.count"),
    COUNT_FRONT_COMPONENT_LIST("third.front.count"),
    //三方消息拉取服务名称
    MESSAGE_PULL("message.pull"),

    // 三方应用业务待办分组类型
    BUSINESS_TODO_GROUP("business.todo.group"),
    // 三方应用业务待办数
    BUSINESS_TODO_VALUE("business.todo.value");

    private String serviceName;

    EAIServiceNameEnum(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return serviceName;
    }
}
