package com.digiwin.athena.semc.common.enums;

import com.google.common.collect.Lists;
import lombok.Getter;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Getter
public enum EventTypeEnum {
    BACK_TO_WORKBENCH_BUTTON_CLICK(1, "backToWorkbenchButtonClick", "点击返回工作台按钮"),
    SEARCH_MENU(2, "searchMenu", "点击搜索栏"),
    TENANT_SWITCH_BUTTON_CLICK(3, "tenantSwitchButtonClick", "点击租户切换按钮"),
    LOGIN_OUT_CLICK(4, "loginOutClick", "点击登出按钮"),
    LOGIN_OUT_CANCEL_CLICK(5, "loginOutCancelClick", "点击取消登出按钮"),
    LOGIN_OUT_CONFIRM_CLICK(6, "loginOutConfirmClick", "登出"),
    BACKGROUND_MENU_CLICK(7, "backgroundMenuClick", "点击后台菜单"),
    HOST_SEMC_URL(8, "host_semc_url", "管理后台看是否有人访问semc网址埋点"),
    LOGIN_CLICK(9, "loginClick", "登录"),
    WORK_AUTHORIZATION(10, "workAuthorization", "管理后台赋权"),
    THIRD_TODO_CLICK(11, "thirdTodoClick", "查看三方待办"),
    THIRD_MESSAGE_CLICK(12, "thirdMessageClick", "查看三方消息"),
    CUSTOM_PORTAL_CLICK(13, "customPortalClick", "使用工作台"),
    COMPONENT_CLICK(14, "componentClick", "点击部件");

    private final Integer eventType;
    private final String eventId;
    private final String desc;

    EventTypeEnum(Integer eventType, String eventName, String desc) {
        this.eventType = eventType;
        this.eventId = eventName;
        this.desc = desc;
    }

    public static List<Integer> getAllEventType() {
        return Arrays.stream(EventTypeEnum.values())
                .map(EventTypeEnum::getEventType)
                .collect(Collectors.toList());
    }

    public static List<String> getAllEventName() {
        return Arrays.stream(EventTypeEnum.values())
                .map(EventTypeEnum::getEventId)
                .collect(Collectors.toList());
    }

    public static List<String> getWorkbenchEventName() {
        return Arrays.asList(
                LOGIN_OUT_CONFIRM_CLICK.getEventId(),
                LOGIN_CLICK.getEventId(),
                WORK_AUTHORIZATION.getEventId(),
                THIRD_TODO_CLICK.getEventId(),
                THIRD_MESSAGE_CLICK.getEventId(),
                CUSTOM_PORTAL_CLICK.getEventId(),
                COMPONENT_CLICK.getEventId()
        );
    }

    public static List<String> getEventIdByEventType(List<Integer> eventTypes) {
        List<String> eventNames = Lists.newArrayList();
        if (CollectionUtils.isEmpty(eventTypes)) {
            return eventNames;
        }
        eventTypes.forEach(eventType -> {
            for (EventTypeEnum eventTypeEnum : EventTypeEnum.values()) {
                if (eventTypeEnum.getEventType().equals(eventType)) {
                    eventNames.add(eventTypeEnum.getEventId());
                    break;
                }
            }
        });
        return eventNames;
    }

    public static Integer getEventTypeByEventId(String eventName) {
        for (EventTypeEnum eventTypeEnum : EventTypeEnum.values()) {
            if (eventTypeEnum.getEventId().equals(eventName)) {
                return eventTypeEnum.getEventType();
            }
        }
        return null;
    }

    public static String getDescByEventId(String eventName) {
        for (EventTypeEnum eventTypeEnum : EventTypeEnum.values()) {
            if (eventTypeEnum.getEventId().equals(eventName)) {
                return eventTypeEnum.getDesc();
            }
        }
        return null;
    }
}
