package com.digiwin.athena.semc.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.baomidou.mybatisplus.annotation.IEnum;

/**
 * @description: 目录层级枚举
 * @createDate: 2023/7/19
 * @author: sungqz
 */
public enum FolderLevelEnum implements IEnum<Integer> {
    FIRST(1), // 一级目录
    SECOND(2), // 二级目录
    THIRD(3);// 三级目录

    @EnumValue
    private Integer level;

    FolderLevelEnum(Integer level) {
        this.level = level;
    }

    @Override
    public Integer getValue() {
        return level;
    }
}
