package com.digiwin.athena.semc.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.baomidou.mybatisplus.annotation.IEnum;

/**
 * 首页搜索结果枚举值 0：项目卡 1：任务卡 2：发起项目 3：基础资料录入
 * 4：报表 5：友情链接应用 6：其他 7:三方待办  8:三方报表 9：公司新闻   10：通知公告
 */
public enum HomeSearchTypeEnum implements IEnum<Integer> {
    ITEM_CARD(0),// 项目卡
    TASK_CARD(1),// 任务卡
    INITIATES_PROJECTS(2),// 发起项目
    BASIC_DATA(3),// 基础资料录入
    REPORT(4),// 报表
    APP_LINK(5),// 友情链接应用
    OTHER(6),// 其他
    THREE_TODO(7),// 三方待办
    THREE_REPORT(8),// 三方报表
    NEWS(9),// 新闻
    NOTICE(10),// 公告
    FINE_REPORT(11),// 帆软报表
    KBS_FILE(12);// 文档




    @EnumValue
    private Integer type;

    HomeSearchTypeEnum(Integer type) {
        this.type = type;
    }

    @Override
    public Integer getValue() {
        return type;
    }
}
