package com.digiwin.athena.semc.common.enums;


import java.util.Arrays;

public enum MQMessageTypeEnum {
    NEWS_LIKE(1,"公告点赞"),
    NEWS_FAVORITE(2, "公告收藏"),
    NEWS_CANCEL_FAVORITE(3,"公告取消收藏"),
    NEWS_SEND_NOTICE(4,"公告发送工作提醒");

    private Integer code;
    private String value;

    MQMessageTypeEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public Integer getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    public static MQMessageTypeEnum getEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }

        return Arrays.stream(values()).filter(s -> s.getCode().equals(code)).findFirst().orElse(null);
    }
}
