package com.digiwin.athena.semc.common.enums;

import org.apache.commons.lang3.StringUtils;

public enum MaycurCulomnEnum {
    /**
     *
     */
    CODE ("type","单据类型"),

    BUSINESSCODE("businessCode","单据号"),

    TYPE("name","申请事由"),

    NAME("reimUserName","申请人"),

    SUBMITTEDAT("coverName(departmentName)","费用归属"),

    SUBMITTER("submittedAt","提单时间"),

    SUBMITTEREMPLOYEEID("status","报销状态");


    MaycurCulomnEnum(String column,String desc){
        this.column = column;
        this.desc = desc;

    }


    public static String getDesc(String column) {
        if(!StringUtils.isEmpty(column)) {
            for (MaycurCulomnEnum compareColumns : MaycurCulomnEnum.values()) {
                if(compareColumns.getColumn().equals(column)) {
                    return compareColumns.getDesc();
                }
            }
        }
        return null;
    }

    private final String column;

    private final String desc;

    public String getColumn() {
        return column;
    }

    public String getDesc() {
        return desc;
    }
}
