package com.digiwin.athena.semc.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @description: 每刻任务类型
 */
public enum MaycurTaskActionTypeEnum {

    PROCESSING("PROCESSING"), // 待处理
    COMPLETED("COMPLETED"), // 完成
    REJECTED("REJECTED"), // 驳回
    REJECTED_TO_PREVIOUS("REJECTED_TO_PREVIOUS"), // 驳回到之前的任务处理人
    RECALLED("RECALLED"), // 召回
    FORWARD("FORWARD"), // 转发
    REVERTED("REVERTED"), // 撤回
    DELEGATE("DELEGATE"), // 转派
    COUNTERSIGN("COUNTERSIGN"), // 加签
    DELETE("DELETE"), // 删除
    PROCESS_COMPLETED("PROCESS_COMPLETED"), // 流程完成
    BE_REJECTED("BE_REJECTED"), // 驳回提单人
    CARBON_COPY("CARBON_COPY"); // 抄送


    @EnumValue
    @JsonValue // 标记响应json值
    private String type;

    MaycurTaskActionTypeEnum(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }
}
