package com.digiwin.athena.semc.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.baomidou.mybatisplus.annotation.IEnum;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @description: 预设应用类型枚举
 * @createDate: 2023/1/29 13:14
 * @author: sunyfa
 */
public enum PreinstalledApplicationTypeEnum implements IEnum<String> {
    BS_APPLICATION("1"), CS_APPLICATION("2"), SPECIAL_APPLICATION("3"), IAM_APPLICATION("4");

    @EnumValue
    @JsonValue // 标记响应json值
    private String type;

    PreinstalledApplicationTypeEnum(String type) {
        this.type = type;
    }

    public static PreinstalledApplicationTypeEnum fromInt(String type) {
        switch (type) {
            case "1":
                return BS_APPLICATION;
            case "2":
                return CS_APPLICATION;
            case "3":
                return SPECIAL_APPLICATION;
            default:
                return null;
        }
    }

    public String getType() {
        return type;
    }

    @Override
    public String getValue() {
        return type;
    }
}
