package com.digiwin.athena.semc.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @description: TW应用跳转地址变量枚举
 */
public enum TWAppUrlVariableEnum {

    IAM_USER_ID("${iamUserId}"),
    MOBILE_TOKEN("${mobile_token}"),
    COMPANY_ID("${companyID}"),
    LOCALE("${locale}"),
    PERSON_ID("${robamAppUid}"),
    ACCESS_TOKEN("${access_token}");

    @EnumValue
    @JsonValue
    private String variableName;

    TWAppUrlVariableEnum(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        return variableName;
    }
}
