package com.digiwin.athena.semc.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.baomidou.mybatisplus.annotation.IEnum;


/**
 * 版更提醒类型枚举
 *
 * @author sungqz
 * @since 2025-04-08
 */
public enum UpgradePriorityEnum implements IEnum<Integer> {
    COMMON_UPGRADE(1), // 普通升级说明
    IMPORTANT_UPGRADE(2), // 重要升级说明
    STRONG_REMINDER_UPGRADE(3); // 重要升级说明

    @EnumValue
    private Integer type;

    UpgradePriorityEnum(Integer type) {
        this.type = type;
    }

    @Override
    public Integer getValue() {
        return type;
    }
}
