package com.digiwin.athena.semc.common.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 虚拟应用的枚举
 *
 * @author sungqz
 * @since 2024-07-29
 */
public enum VirtualApplicationEnum {
    // 雅典娜智驱平台
    ATHENA_AGILE_INTERACTION("99990", "agileInteraction", "雅典娜智驱平台"),
    //鼎捷雅典娜APP
    ATHENA_APP("99991", "athenaApp", "鼎捷雅典娜APP"),
    // 帆软应用
    FINE_REPORT_APP("99992", "FineReport", "帆软");


    /**
     * 主键id
     */
    private final String primaryId;

    /**
     * 应用code
     */
    private final String code;

    /**
     * 应用名称
     */
    private final String name;

    VirtualApplicationEnum(String primaryId, String code, String name) {
        this.primaryId = primaryId;
        this.code = code;
        this.name = name;
    }

    public String getPrimaryId() {
        return primaryId;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    /**
     * 通过主键id获取应用名称
     *
     * @param primaryId 主键id
     * @return 应用名称
     */
    public static String parseNameById(String primaryId) {
        if (StringUtils.isNotBlank(primaryId)) {
            for (VirtualApplicationEnum virtualApplicationEnum : VirtualApplicationEnum.values()) {
                if (virtualApplicationEnum.getPrimaryId().equals(primaryId)) {
                    return virtualApplicationEnum.getName();
                }
            }
        }
        return null;
    }

    /**
     * 通过主键id获取应用Code
     *
     * @param primaryId 主键id
     * @return 应用名称
     */
    public static String parseCodeById(String primaryId) {
        if (StringUtils.isNotBlank(primaryId)) {
            for (VirtualApplicationEnum virtualApplicationEnum : VirtualApplicationEnum.values()) {
                if (virtualApplicationEnum.getPrimaryId().equals(primaryId)) {
                    return virtualApplicationEnum.getCode();
                }
            }
        }
        return null;
    }
}
