package com.digiwin.athena.semc.configuration;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.HashSet;
import java.util.Set;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-10-28 09:42
 **/
@Configuration
public class AppConfiguration implements WebMvcConfigurer, InitializingBean {
    private static final Set<String> tenantIgnoreTables = new HashSet<>();

//    @Override
//    public void addCorsMappings(CorsRegistry registry) {
//        registry.addMapping("/**")
//                .allowedOriginPatterns("*")
//                .allowedMethods("*")
//                .allowedHeaders("*")
//                .allowCredentials(true)
//                .maxAge(7200);
//    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor(new PaginationInnerInterceptor(DbType.MYSQL));
        interceptor.addInnerInterceptor(new TenantLineInnerInterceptor(new DynamicTenantLineHandler()));
        return interceptor;
    }

    public static class DynamicTenantLineHandler implements TenantLineHandler {
        private static final ThreadLocal<Boolean> IGNORE_TENANT = new ThreadLocal<>();

        public static void ignoreTenant() {
            IGNORE_TENANT.set(Boolean.TRUE);
        }

        public static void clear() {
            IGNORE_TENANT.remove();
        }

        @Override
        public Expression getTenantId() {
            return new StringValue(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        }

        @Override
        public String getTenantIdColumn() {
            return "tenant_id";
        }

        @Override
        public boolean ignoreTable(String tableName) {
            return BooleanUtils.isNotTrue(IGNORE_TENANT.get()) && tenantIgnoreTables.contains(tableName);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        tenantIgnoreTables.add("t_homepage_logo");
        tenantIgnoreTables.add("t_homepage_label");
        tenantIgnoreTables.add("t_label_system");
        tenantIgnoreTables.add("t_portal_layout");
        tenantIgnoreTables.add("preinstalled_application");
        tenantIgnoreTables.add("upgrade_browse_detail");
        tenantIgnoreTables.add("action_function_mapping");
        tenantIgnoreTables.add("user_portal_record");
        tenantIgnoreTables.add("t_message_channel_base");
		tenantIgnoreTables.add("t_platform_config");
        tenantIgnoreTables.add("t_label_system_pre");
        tenantIgnoreTables.add("t_portal_layout_custom");
        tenantIgnoreTables.add("t_third_message_info");
        tenantIgnoreTables.add("t_third_message_read_info");
        tenantIgnoreTables.add("t_sync_job_info");
        tenantIgnoreTables.add("t_sync_job_history");
        tenantIgnoreTables.add("semc_todo");
        tenantIgnoreTables.add("semc_todo_read");
        tenantIgnoreTables.add("semc_todo_field");
        tenantIgnoreTables.add("t_topic_preset");
        tenantIgnoreTables.add("t_email_company_mapping");
        tenantIgnoreTables.add("t_sync_todo_record");
        tenantIgnoreTables.add("semc_import_template");
        tenantIgnoreTables.add("t_manage_menu");
        tenantIgnoreTables.add("t_template_system_pre");
        tenantIgnoreTables.add("t_platform_init_config");
        tenantIgnoreTables.add("t_tenant_attribute_def");
        tenantIgnoreTables.add("workbench_related_app");
        tenantIgnoreTables.add("workbench_app_custom_setting");
        tenantIgnoreTables.add("workbench_image");
        tenantIgnoreTables.add("t_label_system_custom");
        tenantIgnoreTables.add("t_portal_deploy_message");
        tenantIgnoreTables.add("t_tripartite_application_base");
        tenantIgnoreTables.add("t_third_message_type");
        tenantIgnoreTables.add("T_REPORT");
    }
}
