package com.digiwin.athena.semc.configuration;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.util.DateUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

/**
 * @Description 自动填充
 * @Author sungq
 * @Date 2022/11/16
 **/
@Component
public class CommonObjectHandler implements MetaObjectHandler {

    /**
     * 新增
     *
     * @param metaObject
     */
    @Override
    public void insertFill(MetaObject metaObject) {
        String nowTime = DateUtils.getNowTime(DateUtils.DATE_TIME_NORMAL_FORMATTER);
        this.setFieldValByName("createTime", nowTime, metaObject);
        this.setFieldValByName("modifyTime", nowTime, metaObject);
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        if (user == null) {
            return;
        }
        this.setFieldValByName("createUserId", user.getUserId(), metaObject);
        this.setFieldValByName("modifyUserId", user.getUserId(), metaObject);
        this.setFieldValByName("createUserName", user.getUserName(), metaObject);
        this.setFieldValByName("modifyUserName", user.getUserName(), metaObject);
    }

    /**
     * 更新
     *
     * @param metaObject
     */
    @Override
    public void updateFill(MetaObject metaObject) {
        this.setFieldValByName("modifyTime", DateUtils.getNowTime(DateUtils.DATE_TIME_NORMAL_FORMATTER), metaObject);
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        if (user == null){
            return;
        }
        this.setFieldValByName("modifyUserId", user.getUserId(), metaObject);
        this.setFieldValByName("modifyUserName", user.getUserName(), metaObject);
    }
}