package com.digiwin.athena.semc.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

import javax.servlet.http.HttpServletRequest;
import java.util.Locale;

/**
 * @author sungq
 * 扩展spring 中的一些默认配置
 */
@Configuration
public class CustomerWebMvcConfigurationSupport extends WebMvcConfigurationSupport {

//    @Override
//    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
//        for (HttpMessageConverter<?> httpMessageConverter : converters) {
//            if (MappingJackson2HttpMessageConverter.class.isInstance(httpMessageConverter)) {
//                ((MappingJackson2HttpMessageConverter) httpMessageConverter).setObjectMapper(JsonUtils.createObjectMapper());
//            }
//        }
//    }

    /**
     * 允许跨域访问
     *
     * @param registry
     */
//    @Override
//    public void addCorsMappings(CorsRegistry registry) {
//        registry.addMapping("/**")
//                .allowedOrigins("*")
//                .allowedMethods("POST", "GET", "PUT", "OPTIONS", "DELETE", "PATCH", "HEAD")
//                .allowedHeaders("*")
//                .maxAge(3600)
//                .allowCredentials(true);
//    }

    /**
     * 根据参数lang切换多语言
     *
     * @param registry
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        LocaleChangeInterceptor localeInterceptor = new LocaleChangeInterceptor();
        localeInterceptor.setParamName("lang");
        registry.addInterceptor(localeInterceptor);
    }

    @Bean
    public LocaleResolver localeResolver() {
        AcceptHeaderLocaleResolver localeResolver = new AcceptHeaderLocaleResolver() {
            @Override
            public Locale resolveLocale(HttpServletRequest request) {
                if (!StringUtils.isEmpty(request.getHeader("locale"))) {

                    return Locale.forLanguageTag(request.getHeader("locale").replace('_', '-'));
                }
                return this.getDefaultLocale();
            }
        };

        localeResolver.setDefaultLocale(Locale.forLanguageTag("zh-CN"));
        return localeResolver;
    }


    /**
     * 静态资源访问
     *
     * @param registry
     * @author yanfeng
     */
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/**").addResourceLocations("classpath:/META-INF/resources/")
                .addResourceLocations("classpath:/resources/").addResourceLocations("classpath:/static/")
                .addResourceLocations("classpath:/public/");
        super.addResourceHandlers(registry);
    }

}
