package com.digiwin.athena.semc.configuration;

import com.digiwin.athena.esp.sdk.init.EspSdkInitialize;
import com.digiwin.athena.semc.env.EnvProperties;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @Author: sunyfa
 * @CreateTime: 2022/12/9 10:57
 * @Description: 加载 ESP 对接需要的必要参数
 * @Version: 1.0
 */
@Component
public class ESPInitConfiguration implements ApplicationRunner {
    @Resource
    private EnvProperties envProperties;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        EspSdkInitialize.initConfig(envProperties.getEspDomain(), envProperties.getMdcDomain(),
                envProperties.getKmDomain(), envProperties.getEocDomain());

        EspSdkInitialize.initAppConfig("semc", envProperties.getAthenaAppToken());

        EspSdkInitialize.enableEspRouting(true);
    }
}
