package com.digiwin.athena.semc.configuration;

import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.stereotype.Component;

/**
 *
 * 临时兼容ops和nacos的mongo配置 后期可以删除 todo
 */
@Component
public class MongoOpsNacosPropertiesPostProcessor implements BeanPostProcessor {
    
    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof MongoProperties) {
            MongoProperties mongoProperties = (MongoProperties) bean;
            customizeMongoProperties(mongoProperties);
        }
        return bean;
    }
    
    private void customizeMongoProperties(MongoProperties properties) {
        if (properties.getPassword() != null) {
            properties.setPassword(null);
        }
        
        if (properties.getUsername() != null) {
            properties.setUsername(null);
        }
    }
}