package com.digiwin.athena.semc.configuration;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
public class MongoTemplateConfig {

    @Value("${spring.data.mongodb.uri}")
    private String uriLog;

    @Value("${spring.data.mongodb.database}")
    private String databaseLog;

    @Value("${spring.data.mongodb-applink.uri}")
    private String uriAppLink;

    @Value("${spring.data.mongodb-applink.database}")
    private String databaseAppLink;


    @Bean("mongoTemplate")
    public MongoTemplate mongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriLog)).build(), null);
        return new MongoTemplate(client, databaseLog);
    }

    @Bean("appLinkMongoTemplate")
    public MongoTemplate appLinkMongoTemplate() {

        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriAppLink)).build(), null);
        return new MongoTemplate(client, databaseAppLink);

//        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriAppLink)).build(), null);
//        MongoTemplate msgMongoTemplate = new MongoTemplate(client, databaseAppLink);
//        MongoConverter converter = msgMongoTemplate.getConverter();
//        // 去掉_class属性
//        if (converter.getTypeMapper().isTypeKey("_class")) {
//            ((MappingMongoConverter) converter).setTypeMapper(new DefaultMongoTypeMapper(null));
//        }
//
//        return msgMongoTemplate;
    }
}
