//package com.digiwin.athena.semc.configuration;
//
//import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
//import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
//import com.digiwin.athena.semc.service.workbench.constant.WorkBenchConstant;
//import com.digiwin.athena.semc.util.Utils;
//import net.sf.jsqlparser.JSQLParserException;
//import net.sf.jsqlparser.expression.Expression;
//import net.sf.jsqlparser.expression.StringValue;
//import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
//import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
//import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
//import net.sf.jsqlparser.expression.operators.relational.InExpression;
//import net.sf.jsqlparser.parser.CCJSqlParserUtil;
//import net.sf.jsqlparser.schema.Column;
//import net.sf.jsqlparser.statement.Statement;
//import net.sf.jsqlparser.statement.delete.Delete;
//import net.sf.jsqlparser.statement.select.PlainSelect;
//import net.sf.jsqlparser.statement.update.Update;
//import net.sf.jsqlparser.util.TablesNamesFinder;
//import org.apache.commons.collections4.CollectionUtils;
//import org.apache.ibatis.executor.Executor;
//import org.apache.ibatis.mapping.BoundSql;
//import org.apache.ibatis.mapping.MappedStatement;
//import org.apache.ibatis.plugin.Intercepts;
//import org.apache.ibatis.plugin.Signature;
//import org.apache.ibatis.session.ResultHandler;
//import org.apache.ibatis.session.RowBounds;
//
//import java.lang.reflect.Method;
//import java.util.ArrayList;
//import java.util.Arrays;
//import java.util.HashSet;
//import java.util.List;
//import java.util.Map;
//import java.util.Set;
//import java.util.stream.Collectors;
//
//@Intercepts({
//        @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}),
//        @Signature(type = Executor.class, method = "update", args = {MappedStatement.class, Object.class})
//})
//public class MultiTenantInnerInterceptor2 implements InnerInterceptor {
//    private static final String TENANT_COLUMN = "tenant_id";
//
//    @Override
//    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
//        rewriteSql(ms, boundSql);
//    }
//
//    @Override
//    public void beforeUpdate(Executor executor, MappedStatement ms, Object parameter) {
//        BoundSql boundSql = ms.getBoundSql(parameter);
//        rewriteSql(ms, boundSql);
//    }
//
//    private void rewriteSql(MappedStatement ms, BoundSql boundSql) {
//        if (isTenantLineIgnored(ms) || isIgnoreTable(boundSql.getSql())) {
//            return;
//        }
//
//        List<String> tenantIds = new ArrayList<>(new HashSet<>(Arrays.asList(Utils.getTenantId(), WorkBenchConstant.SYSTEM_TENANT)));
//        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql(boundSql);
//        try {
//            String sql = boundSql.getSql();
//            net.sf.jsqlparser.statement.Statement stmt = CCJSqlParserUtil.parse(sql);
//
//            if (stmt instanceof net.sf.jsqlparser.statement.select.Select) {
//                processSelect((net.sf.jsqlparser.statement.select.Select) stmt, tenantIds);
//            } else if (stmt instanceof Update) {
//                processUpdate((Update) stmt, tenantIds);
//            } else if (stmt instanceof Delete) {
//                processDelete((Delete) stmt, tenantIds);
//            }
//
//            mpBs.sql(stmt.toString());
//        } catch (JSQLParserException e) {
//            throw new RuntimeException("多租户 SQL 改写失败: " + e.getMessage(), e);
//        }
//    }
//
//    private void processSelect(net.sf.jsqlparser.statement.select.Select select, List<String> tenantIds) {
//        net.sf.jsqlparser.statement.select.PlainSelect plain = (PlainSelect) select.getSelectBody();
//        Expression tenantCond = createTenantCondition(tenantIds);
//        Expression where = plain.getWhere();
//
//        if (where != null) {
//            plain.setWhere(new AndExpression(tenantCond, where));
//        } else {
//            plain.setWhere(tenantCond);
//        }
//    }
//
//    private void processUpdate(Update update, List<String> tenantIds) {
//        Expression tenantCond = createTenantCondition(tenantIds);
//        Expression where = update.getWhere();
//        if (where != null) {
//            update.setWhere(new AndExpression(tenantCond, where));
//        } else {
//            update.setWhere(tenantCond);
//        }
//    }
//
//    private void processDelete(Delete delete, List<String> tenantIds) {
//        Expression tenantCond = createTenantCondition(tenantIds);
//        Expression where = delete.getWhere();
//        if (where != null) {
//            delete.setWhere(new AndExpression(tenantCond, where));
//        } else {
//            delete.setWhere(tenantCond);
//        }
//    }
//
//    private Expression createTenantCondition(List<String> tenantIds) {
//        Column column = new Column(TENANT_COLUMN);
//
//        if (tenantIds.size() == 1) {
//            return new EqualsTo(column, new StringValue(tenantIds.iterator().next()));
//        }
//
//        InExpression inExpr = new InExpression();
//        inExpr.setLeftExpression(column);
//        List<Expression> exprList = tenantIds.stream()
//                .map(StringValue::new)
//                .collect(Collectors.toList());
//        inExpr.setRightItemsList(new ExpressionList(exprList));
//        return inExpr;
//    }
//
//    private boolean isIgnoreTable(String sql) {
//        Set<String> tableNames = extractTableNames(sql);
//        // 有交集，代表忽略
//        return CollectionUtils.intersection(tableNames, AppConfiguration.tenantIgnoreTables).size() > 0;
//    }
//
//    /**
//     * 使用 TablesNamesFinder 从 SQL 中提取所有表名
//     */
//    private Set<String> extractTableNames(String sql) {
//        try {
//            Statement stmt = CCJSqlParserUtil.parse(sql);
//            TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
//            List<String> tableList = tablesNamesFinder.getTableList(stmt);
//
//            // 转小写，避免大小写问题
//            return tableList.stream().map(String::toLowerCase).collect(Collectors.toSet());
//        } catch (Exception e) {
//            // 解析失败时，保守处理：不添加租户条件，避免误伤
//            throw new RuntimeException("SQL 表名解析失败: " + sql, e);
//        }
//    }
//
//    private static final Map<String, Method> METHOD_CACHE = new java.util.concurrent.ConcurrentHashMap<>();
//
//    /**
//     * 判断当前 MappedStatement 是否应忽略租户过滤
//     */
//    private boolean isTenantLineIgnored(MappedStatement ms) {
//        Method method = MultiTenantInnerInterceptor2.getMethod(ms);
//        if (method != null) {
//            com.baomidou.mybatisplus.annotation.InterceptorIgnore ignore =
//                    method.getAnnotation(com.baomidou.mybatisplus.annotation.InterceptorIgnore.class);
//            if (ignore != null && "true".equalsIgnoreCase(ignore.tenantLine())) {
//                return true;
//            }
//        }
//        return false;
//    }
//
//    /**
//     * 根据 MappedStatement 获取对应的 Method
//     */
//    public static Method getMethod(MappedStatement ms) {
//        return METHOD_CACHE.computeIfAbsent(ms.getId(), key -> {
//            // 解析：com.example.UserMapper.selectById → com.example.UserMapper + selectById
//            int lastDot = key.lastIndexOf('.');
//            if (lastDot <= 0) {
//                return null;
//            }
//
//            String className = key.substring(0, lastDot);
//            String methodName = key.substring(lastDot + 1);
//
//            try {
//                Class<?> mapperInterface = Class.forName(className);
//                for (Method method : mapperInterface.getMethods()) {
//                    if (method.getName().equals(methodName)) {
//                        return method;
//                    }
//                }
//            } catch (ClassNotFoundException e) {
//                System.err.println("Mapper 接口未找到: " + className);
//            } catch (NoClassDefFoundError e) {
//                System.err.println("类定义错误: " + className);
//            } catch (Exception e) {
//                System.err.println("解析 Method 异常: " + key + ", " + e.getMessage());
//            }
//            return null;
//        });
//    }
//}
