package com.digiwin.athena.semc.configuration;

import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitConfig {

    //semc通用消息工作队列（一个消息，只有一个消费者可消费，只需要生产端、消费端、队列）
    public static final String SEMC_WORK_COMMON_QUEUE_NAME = "semc.work.common.queue";


    @Bean
    public Queue semcWorkCommonQueue() {
        //该方法底层就是持久化
        return QueueBuilder.durable(SEMC_WORK_COMMON_QUEUE_NAME).build();
    }


}
