package com.digiwin.athena.semc.configuration;

import com.digiwin.athena.semc.common.enums.MQMessageTypeEnum;
import com.digiwin.athena.semc.mq.strategy.WorkCommonMessageStrategy;
import com.digiwin.athena.semc.mq.strategy.WorkCommonMessageStrategyRunner;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 策略配置
 */
@Configuration
public class StrategyConfig {

    @Bean
    public WorkCommonMessageStrategyRunner workCommonMessageStrategyRunner(List<WorkCommonMessageStrategy> strategies) {
        Map<MQMessageTypeEnum, WorkCommonMessageStrategy> strategyMap = strategies.stream().collect(Collectors.toMap(WorkCommonMessageStrategy::getType, s -> s));
        return messageDTO -> strategyMap.get(MQMessageTypeEnum.getEnumByCode(messageDTO.getMessageType())).doHandler(messageDTO);
    }
}
