package com.digiwin.athena.semc.configuration.mqtt;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
@JsonIgnoreProperties("$$beanFactory")
@ConfigurationProperties(prefix = "spring.mqtt")
public class MqttProperties {
    private String serverName;
    private String username;
    private String password;
    private String url;
    private String clientId;
    private String  defaultTopic = "TOPIC_DEFAULT";
    private Integer completionTimeout = 2000;
    private String serverQueryUrl;
    private String serverQueryUsername;
    private String serverQueryPassword;
    private Integer maxInflight = 1000;

}
