package com.digiwin.athena.semc.controller;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.semc.dto.AuthReqDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.*;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.Map;

/**
 * @author CR-7
 * create: 2024-03-11 17:18
 * Description: 应用授权认证校验
 */
@Slf4j
@RestController
@RequestMapping("/semc/auth")
public class AuthController {

    @Resource
    private EnvProperties envProperties;

    @Resource
    private RestTemplate restTemplate;

    /**
     *  应用授权校验
     * @param authReqDTO
     * @return
     */
    @Operation(method = "verifyAppAuthorized",description = "应用授权认证校验")
    @PostMapping("/verifyAppAuthorized")
    public ResponseEntity<BaseResultDTO<Boolean>> check(@RequestBody @Valid AuthReqDTO authReqDTO) {
        String  tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        String url = envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/" + tenantId + "/goods/" + authReqDTO.getGoodsCode();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", envProperties.getAppToken());
            headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(null, headers);
            ResponseEntity<Map> response = restTemplate.exchange(url, HttpMethod.GET, requestEntity, Map.class);
            log.debug("verify if the app is authorized, tenantId:{}, code:{}, result:{}", tenantId, authReqDTO.getGoodsCode(), JsonUtils.objectToString(response));

            if (response.getBody() != null && response.getBody().containsKey("purchaseId")) {
                return ResponseEntityWrapperUtil.wrapperOk(true);
            }
        } catch (Exception e) {
            log.error("verify if the app is authorized occur error, tenantId:{}, code:{}", tenantId, authReqDTO.getGoodsCode(), e);
        }
        return ResponseEntityWrapperUtil.wrapperOk(false);

    }
}
