package com.digiwin.athena.semc.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ParamBean;
import com.digiwin.athena.semc.common.ResultBean;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-10-31 08:59
 **/

public abstract class BasicController<S extends IService<T>, T> {

    @Autowired
    protected S baseService;

    @Operation(summary = "保存")
    @PostMapping("save")
    public ResultBean save(@RequestBody T info) {
        baseService.saveOrUpdate(info);
        return ResultBean.success(info);
    }

    @Operation(summary = "删除")
    @DeleteMapping("delete")
    public ResultBean delete(Long id) {
        Boolean r = baseService.removeById(id);
        return ResultBean.success(r);
    }

    @Operation(summary = "根据id查询")
    @GetMapping("get")
    public ResultBean get(Long id) {
        T info = baseService.getById(id);
        return ResultBean.success(info);
    }

    @Operation(summary = "根据条件分页查询")
    @PostMapping("query")
    public ResultBean query(@RequestBody ParamBean<T> paramBean) {
        ResultBean resultBean = new ResultBean();
        QueryWrapper queryWrapper = new QueryWrapper(paramBean.getValue());
        if (null != paramBean.getSortField()) {
            if (Constants.desc.equalsIgnoreCase(paramBean.getSortType())) {
                queryWrapper.orderByDesc(paramBean.getSortField());
            }
            else {
                queryWrapper.orderByAsc(paramBean.getSortField());
            }
        }

        Page<T> pages = baseService.page(
            Page.of(paramBean.getPageIndex() * Long.valueOf(paramBean.getPageSize()), paramBean.getPageSize()),
            queryWrapper);
        resultBean.setResponse(pages.getRecords());

        return resultBean;
    }

}
