package com.digiwin.athena.semc.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.dto.common.TranslateReq;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * 通用类接口
 *
 * @author sungqz
 * @since 2024-06-26
 */
@Slf4j
@RestController
@RequestMapping("/semc/common")
public class CommonController {

    @Resource
    private TranslateService translateService;

    @Resource
    private MessageUtils messageUtils;

    /**
     * 封装的DAP文本翻译接口
     *
     * @return 查询结果
     */
    @PostMapping("/trans/translate")
    public ResponseEntity<BaseResultDTO<JSONObject>> translate(@RequestBody TranslateReq translateReq) {
        try {
            JSONObject jsonObject = translateService.translateTextPackage(translateReq);
            return ResponseEntityWrapperUtil.wrapperOk(jsonObject);
        } catch (Exception e) {
            log.error("CommonController translate text error. param:{}", translateReq, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/common/trans/translate, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }


    @GetMapping("/downFile")
    public ResponseEntity<org.springframework.core.io.Resource> downFile(String path) throws IOException {
        if (StringUtils.isBlank(path)) {
            throw new RuntimeException("文件路径为空");
        }
        // 文件路径
        Path filePath = Paths.get(path);
        org.springframework.core.io.Resource resource = new UrlResource(filePath.toUri());

        if (resource.exists() || resource.isReadable()) {
            // 设置响应头
            HttpHeaders headers = new HttpHeaders();
            headers.add(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\"" + resource.getFilename() + "\"");
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);

            // 使用流式传输
            return ResponseEntity.ok()
                    .headers(headers)
                    .contentLength(resource.contentLength())
                    .body(resource);
        } else {
            throw new RuntimeException("文件不存在或不可读");
        }
    }
}