package com.digiwin.athena.semc.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.eai.DigiSrvcode;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.athena.semc.dto.DWEAIResultBean;
import com.digiwin.athena.semc.dto.EaiResp;
import com.digiwin.athena.semc.service.eai.EaiService;
import com.digiwin.athena.semc.util.ReqAndRespUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@RestController
@RequestMapping("/semc")
@RequiredArgsConstructor
@Slf4j
public class EaiController {
    @Autowired
    private EaiService eaiService;

    @PostMapping("/eai")
    public EaiResp eai(@RequestBody(required = false) JSONObject eaiJSONObject, HttpServletRequest request, HttpServletResponse response) {
        log.info("EaiController.eai param:{}",JSONObject.toJSONString(eaiJSONObject));
        String digiServiceStr = request.getHeader("digi-service");
        String digiType = request.getHeader("digi-type");
        if ("fasync".equals(digiType)) {
            eaiJSONObject.put("digi-reqid", request.getHeader("digi-reqid"));
        }
        eaiJSONObject.fluentPut("token", request.getHeader("token"));
        ReqAndRespUtil.putParasToResponseHeaders(response);
        EaiResp eaiResp = invoke(JSON.parseObject(digiServiceStr), eaiJSONObject);
        return eaiResp;
    }

    private EaiResp invoke(JSONObject diGiService, JSONObject param) {
        String name = null;
        try {
            name = diGiService.getString("name");
            Class<?> cls = eaiService.getClass();
            Method[] methods = cls.getDeclaredMethods();
            for (Method method : methods) {
                if (null != method.getDeclaredAnnotations()) {
                    EAIService EAIService = method.getAnnotation(EAIService.class);
                    if (Objects.nonNull(EAIService) && EAIService.id().equals(name)) {
                        try {
                            log.info("EAIService invoke start name:{},param:{}", name, JSONObject.toJSONString(param));
                            DWEAIResultBean resultBean = new DWEAIResultBean((DWEAIResult) method.invoke(eaiService, param));
                            Map<String, Object> std_data = resultBean.getStd_data();
                            Object parameter = std_data.get("parameter");
                            return EaiResp.buildSucc(parameter);
                        } catch (Exception e) {
                            log.error("EAIService invoke  error name:{},param:{},e:{}", name,  JSONObject.toJSONString(param), e);
                            return EaiResp.buildError(DigiSrvcode.failure.value(), "-1", ExceptionUtils.getRootCauseMessage(e));
                        }
                    }
                }
            }
            log.info("EAIService invoke service not find name:{},param:{}", name,  JSONObject.toJSONString(param));
            return EaiResp.buildError(DigiSrvcode.failure.value(), "-1", "服务不存在");
        } catch (Exception ex) {
            log.error("EAIService.invoke error name:{},eaiParam:{}", name,  JSONObject.toJSONString(param), ex);
            String description = ExceptionUtils.getRootCauseMessage(ex);
            return EaiResp.buildError(DigiSrvcode.failure.value(), "-1", description);
        }
    }

}
