package com.digiwin.athena.semc.controller;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.service.news.NewsDataAssignService;
import io.swagger.v3.oas.annotations.Operation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


/**
 * 公告数据初始化
 */
@RestController
@RequestMapping("/semc/news/data")
@Slf4j
@RequiredArgsConstructor
public class NewsDataAssignController {

    private final NewsDataAssignService newsDataAssignService;

    /**
     * 公告数据初始化
     *
     * @return 返回
     */
    @Operation(summary = "公告数据初始化")
    @GetMapping("/assign")
    public ResponseEntity<?> start(@RequestParam Boolean removeLockKey) {
        return ResponseEntityWrapper.wrapperOk(newsDataAssignService.startAssign(removeLockKey));
    }
}
