package com.digiwin.athena.semc.controller;

import com.digiwin.athena.semc.common.RedisConstant;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.service.cache.ICacheService;
import io.swagger.v3.oas.annotations.Hidden;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Hidden
@RestController
@RequestMapping("/common")
public class TestController {
    @Resource
    private ICacheService cacheService;

    @GetMapping("/loginInfo")
    public String loginInfo(@RequestBody HttpServletRequest request){
        String token = request.getHeader("token");
        String locale = request.getHeader("locale");
        return "token:" + token + "; locale:" + locale;
    }

    @GetMapping("/recacheTenantApp")
    public ResultBean recacheTenantApp() {
        cacheService.deleteByPrex(RedisConstant.TENANT_SALES_PLAN + "*");

        return ResultBean.success(true);
    }
}
