package com.digiwin.athena.semc.controller;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.dto.menu.manage.UserMenuDataTransferReqDTO;
import com.digiwin.athena.semc.service.menu.UserMenuDataTransferService;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.v3.oas.annotations.Operation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;


/**
 * 用户菜单权限迁移
 */
@RestController
@RequestMapping("/semc/userMenuDataTransfer/")
@Slf4j
@RequiredArgsConstructor
public class UserMenuDataTransferController {

    private final UserMenuDataTransferService userMenuDataTransferService;

    /**
     * 雅典娜下用户菜单权限迁移
     * @return
     */
    @Operation(summary = "雅典娜下用户菜单权限迁移")
    @PostMapping("/start")
    public ResponseEntity<?> start(@RequestBody UserMenuDataTransferReqDTO reqDTO) {
        return ResponseEntityWrapper.wrapperOk(userMenuDataTransferService.startTransfer(reqDTO));
    }
}
