package com.digiwin.athena.semc.controller;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.entity.portal.WorkbenchAppCustomSetting;
import com.digiwin.athena.semc.service.workbenchappcustomsetting.WorkbenchAppCustomSettingService;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by changcong 21064
 * Date 2025/9/26 14:39
 * Description 工作臺應用配置
 */
@RestController
@RequestMapping("/semc/workbenchAppCustomSetting")
public class WorkbenchAppCustomSettingController {

    @Autowired
    private WorkbenchAppCustomSettingService workbenchAppCustomSettingService;

    /**
     * 工作臺應用配置查詢租戶級
     *
     * @return 返回
     */
    @Operation(method = "/tenant/query", description = "工作臺應用配置查詢租戶級")
    @PostMapping("/tenant/query")
    public ResponseEntity<?> tenantQuery() {
        List<WorkbenchAppCustomSetting> workbenchAppCustomSettingList = workbenchAppCustomSettingService.listTenant();
        return ResponseEntityWrapper.wrapperOk(workbenchAppCustomSettingList);
    }

    /**
     * 工作臺應用配置查詢用戶級
     *
     * @return 返回
     */
    @Operation(method = "/user/query", description = "工作臺應用配置查詢用戶級")
    @PostMapping("/user/query")
    public ResponseEntity<?> userQuery() {
        List<WorkbenchAppCustomSetting> workbenchAppCustomSettingList = workbenchAppCustomSettingService.listUser();
        return ResponseEntityWrapper.wrapperOk(workbenchAppCustomSettingList);
    }
}
