package com.digiwin.athena.semc.controller.config;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import lombok.RequiredArgsConstructor;

/**
 * 后台端配置服务
 */
@RestController
@RequestMapping("/semc/backend/common/config/")
@RequiredArgsConstructor
public class BackendCommonConfigController {

    private final CommonConfigService commonConfigService;


    /**
     * 获取公告发布人是否可修改
     * @return
     */
    @PostMapping("/getNewsPublishEditFlag")
    public ResponseEntity<BaseResultDTO<Boolean>> getNewsPublishEditFlag() {
        return ResponseEntityWrapperUtil.wrapperOk(commonConfigService.getNewsPublishEditFlag());
    }


    /**
     * 获取后台菜单是否可操作（添加或编辑）
     */
    @PostMapping("/getBackendMenuOperateFlag")
    public ResponseEntity<BaseResultDTO<Boolean>> getBackendMenuOperateFlag() {
        return ResponseEntityWrapperUtil.wrapperOk(commonConfigService.getBackendMenuOperateFlag());
    }
}
