package com.digiwin.athena.semc.controller.config;


import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.dto.config.MobilePortalCacheConfigParam;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;

import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import lombok.RequiredArgsConstructor;


/**
 * 通用配置服务
 */
@RestController
@RequestMapping("/semc/common/config/")
@RequiredArgsConstructor
public class CommonConfigController {

    private final CommonConfigService commonConfigService;

    private final StringRedisTemplate stringRedisTemplate;


    /**
     * 设置通用配置参数
     *
     * @param req 请求实体
     */
    @PostMapping("/setCommonConfig")
    public ResponseEntity<BaseResultDTO<Boolean>> setCommonConfig(@RequestBody JSONObject req) {
        String key = req.getString("key");
        Object value = req.get("value");
        if (StringUtils.isBlank(key) || value == null) {
            return ResponseEntityWrapperUtil.wrapperOk(Boolean.FALSE);
        }
        String strValue;
        if (value instanceof String) {
            strValue = value.toString();
        } else {
            strValue = JSON.toJSONString(value);
        }
        return ResponseEntityWrapperUtil.wrapperOk(commonConfigService.setCommonConfig(key, strValue));
    }

    /**
     * 获取通用配置参数
     *
     * @param req 请求实体
     */
    @PostMapping("/getCommonConfig")
    public ResponseEntity<BaseResultDTO<Object>> getCommonConfig(@RequestBody JSONObject req) {
        String dataType = req.getString("dataTyoe");
        String key = req.getString("key");
        if (StringUtils.isBlank(dataType) || "string".equals(dataType)) {
            String value = commonConfigService.getCommonConfig(key);
            if (StringUtils.isNotBlank(value)) {
                try {
                    Object object = JSON.parse(value);
                    return ResponseEntityWrapperUtil.wrapperOk(object);
                } catch (Exception e) {
                    return ResponseEntityWrapperUtil.wrapperOk(value);
                }
            }
            return ResponseEntityWrapperUtil.wrapperOk("");
        }
        else if ("set".equals(dataType)){
            SetOperations<String, String> setOperations = stringRedisTemplate.opsForSet();
            return ResponseEntityWrapperUtil.wrapperOk(setOperations.members(key));

        }
        return ResponseEntityWrapperUtil.wrapperOk("");
    }

    /**
     * 删除通用配置参数
     *
     * @param req 请求实体
     */
    @PostMapping("/removeCommonConfig")
    public ResponseEntity<BaseResultDTO<Boolean>> removeCommonConfig(@RequestBody JSONObject req) {
        return ResponseEntityWrapperUtil.wrapperOk(commonConfigService.removeCommonConfig(req.getString("key")));
    }

    /**
     * 设置移动端门户缓存配置参数
     * 内部调用，修改参数
     * @param req 请求实体
     */
    @PostMapping("/setMobilePortalCacheConfigParam")
    public ResponseEntity<BaseResultDTO<Boolean>> setMobilePortalCacheConfigParam(@RequestBody MobilePortalCacheConfigParam req) {
        return ResponseEntityWrapperUtil.wrapperOk(commonConfigService.setMobilePortalCacheConfigParam(req));
    }

}
