package com.digiwin.athena.semc.controller.config;


import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.dto.config.MobilePortalCacheConfigParam;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;

import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import lombok.RequiredArgsConstructor;

/**
 * 移动端配置服务
 */
@RestController
@RequestMapping("/semc/mobile/common/config/")
@RequiredArgsConstructor
public class MobileCommonConfigController {

    private final CommonConfigService commonConfigService;

    /**
     * 获取通用配置参数
     *
     * @param req 请求实体
     */
    @PostMapping("/getCommonConfig")
    public ResponseEntity<BaseResultDTO<Object>> getCommonConfig(@RequestBody JSONObject req) {
        String value = commonConfigService.getCommonConfig(req.getString("key"));
        if (StringUtils.isNotBlank(value)) {
            try {
                Object object = JSON.parse(value);
                return ResponseEntityWrapperUtil.wrapperOk(object);
            } catch (Exception e) {
                return ResponseEntityWrapperUtil.wrapperOk(value);
            }
        }
        return ResponseEntityWrapperUtil.wrapperOk("");
    }


    /**
     * 获取移动端门户缓存配置参数
     */
    @PostMapping("/getPortalCacheConfigParam")
    public ResponseEntity<BaseResultDTO<MobilePortalCacheConfigParam>> getMobilePortalCacheConfigParam() {
        return ResponseEntityWrapperUtil.wrapperOk(commonConfigService.getMobilePortalCacheConfigParam());
    }
}
