package com.digiwin.athena.semc.controller.device;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.annotate.MenuPermissionAuth;
import com.digiwin.athena.semc.dto.device.DeviceBindConfigDTO;
import com.digiwin.athena.semc.service.device.IDeviceBindConfigService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 设备绑定配置控制器
 */
@RestController
@RequestMapping("/semc/device/bind/config")
public class DeviceBindConfigController {

    @Resource
    private IDeviceBindConfigService iDeviceBindConfigService;

    /**
     * 查询租户设备绑定配置
     */
    @GetMapping
    public ResponseEntity<BaseResultDTO<DeviceBindConfigDTO>> getConfig() {
        return ResponseEntityWrapperUtil.wrapperOk(iDeviceBindConfigService.getConfig());
    }

    /**
     * 保存租户设备绑定配置
     */
    @MenuPermissionAuth(code = "account-device-bind")
    @PostMapping("/save")
    public ResponseEntity<BaseResultDTO<Boolean>> saveConfig(@RequestBody DeviceBindConfigDTO config) {
        return ResponseEntityWrapperUtil.wrapperOk(iDeviceBindConfigService.saveConfig(config));
    }
}    