package com.digiwin.athena.semc.controller.fineReport;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.dto.fineReport.QueryFineReportListReq;
import com.digiwin.athena.semc.dto.fineReport.SaveFineReportAuthReq;
import com.digiwin.athena.semc.service.fineReport.FineReportAuthService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * 三方应用-帆软报表权限controller
 *
 * @author sunqgz
 * @since 2025-08-12
 */
@Slf4j
@RestController
@RequestMapping("/semc/tripartite/fineReport/auth")
public class FineReportAuthController {

    @Resource
    private FineReportAuthService fineReportAuthService;

    /**
     * 查询帆软报表列表
     * 调用处：
     * 1、帆软权限配置页面，deviceType不传，即查询全部
     * 2、数据源选择报表下拉框，deviceType传1，即查询pc端报表
     * 3、移动端门户配置选择报表下拉框，deviceType传2，即查询移动端报表
     * 4、小AI全部报表页面，deviceType传1，即查询pc端报表
     *
     * @param queryFineReportListReq 请求对象
     * @return 返回
     */
    @PostMapping("/queryFineReportList")
    public ResponseEntity<?> queryFineReportList(@RequestBody QueryFineReportListReq queryFineReportListReq) {
        JSONObject jsonObject = fineReportAuthService.queryFineReportList(queryFineReportListReq);
        return ResponseEntityWrapperUtil.wrapperOk(jsonObject);
    }

    /**
     * 保存权限对象关联的帆软报表
     *
     * @param saveFineReportAuthReq 请求对象
     * @return 查询结果
     */
    @PostMapping("/saveFineReportAuth")
    public ResponseEntity<BaseResultDTO<Boolean>> saveFineReportAuth(@RequestBody @Valid SaveFineReportAuthReq saveFineReportAuthReq) {
        fineReportAuthService.saveFineReportAuth(saveFineReportAuthReq);
        return ResponseEntityWrapperUtil.wrapperOk(true);
    }
}
