package com.digiwin.athena.semc.controller.homepage.upgrade;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.entity.homepage.BackGroundLogo;
import com.digiwin.athena.semc.service.homepage.IBackGroundLogoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * @description 首页背景图
 * @author: dengkaiwen
 * @create: 2023-8-28
 */
@RestController
@RequestMapping("/semc/background/")
public class BackGroundLogoController {

    private static final Logger logger = LoggerFactory.getLogger(BackGroundLogoController.class);

    @Autowired
    IBackGroundLogoService backGroundLogoService;

    @Resource
    private MessageUtils messageUtils;


    /**
     * 获取租户首页背景图接口
     *
     * @return
     * @throws Exception
     */
    @Operation(summary = "获取租户首页背景图接口")
    @PostMapping("/image/getImage")
    public ResponseEntity<BaseResultDTO<BackGroundLogo>> getImage() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(backGroundLogoService.getBackGroundLogo());
        } catch (Exception e) {
            logger.error("getImage exceptiona", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/background/image/getImage");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }


    /**
     * 保存图片和删除图片
     *
     * @return
     * @throws Exception
     */
    @Operation(summary = "保存背景图")
    @PostMapping("/image/saveImage")
    public ResponseEntity<BaseResultDTO<BackGroundLogo>> saveImage(@RequestBody BackGroundLogo req) {
        try {
            //图片类型（0：模板库选择、1：本地上传,默认1）
            if(req.getImgType() ==null ){
                req.setImgType(1);
            }
            return ResponseEntityWrapperUtil.wrapperOk(backGroundLogoService.saveBackGroundLogo(req));
        } catch (Exception e) {
            logger.error("saveImage exceptiona", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/background/image/saveImage");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

}
