package com.digiwin.athena.semc.controller.homepage.upgrade;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.dto.homepage.HomeSearchDTO;
import com.digiwin.athena.semc.dto.homepage.HomeSearchReq;
import io.swagger.v3.oas.annotations.Operation;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @description 首页搜索
 * @author: dengkaiwen
 * @create: 2023-8-28
 */
@RestController
@RequestMapping("/tenant/semc/")
public class HomeSearchController {

    private static final Logger logger = LoggerFactory.getLogger(HomeSearchController.class);

    @Autowired
    com.digiwin.athena.semc.service.homepage.IHomeSearchService homeSearchService;


    /**
     * 首页搜索
     *
     * @param homeSearchReq 请求实体
     * @return
     * @throws Exception
     */
    @Operation(summary = "首页搜索")
    @PostMapping("/search/result")
    public ResultBean homeSearch(@RequestBody HomeSearchReq homeSearchReq) {
        logger.info("search result param:" + JSON.toJSONString(homeSearchReq));
        ResultBean resultBean = new ResultBean();
        List<HomeSearchDTO>  homeSearchDTOList=new ArrayList<>();
        resultBean.setResponse(homeSearchDTOList);
        //针对搜索内容不为空时，去掉前后空格
        if(StringUtils.isNotEmpty(homeSearchReq.getName())){
            homeSearchReq.setName(homeSearchReq.getName().trim());
        }
        // 参数校验
        if(StringUtils.isEmpty(homeSearchReq.getName())){
            return resultBean;
        }
        //获取租户
        AuthoredUser user =AppAuthContextHolder.getContext().getAuthoredUser();
        if(null ==user){
            return resultBean;
        }
        try {
            homeSearchDTOList=homeSearchService.searchResult(homeSearchReq,user);
            resultBean.setResponse(homeSearchDTOList);
            return resultBean;
        } catch (Exception e) {
            logger.error("search result  error homeSearch:{}, userId:{}", JSON.toJSONString(homeSearchReq), user.getTenantId(), e);
            return resultBean;
        }
    }

    /**
     * 获取KBS文件详情信息
     *
     * @return
     * @throws Exception
     */
    @Operation(summary = "获取KBS文件详情信息")
    @PostMapping("/file/detail")
    public ResultBean getKbsFileDetail(@RequestBody HomeSearchReq homeSearchReq) {
        logger.info("getKbsFileDetail param:" + JSON.toJSONString(homeSearchReq));
        ResultBean resultBean = new ResultBean();
        JSONObject fileDTOList=new JSONObject();
        resultBean.setResponse(fileDTOList);
        // 参数校验
        if(StringUtils.isEmpty(homeSearchReq.getFileId())){
            return resultBean;
        }
        try {
            fileDTOList=homeSearchService.getKbsFileDetail(homeSearchReq.getFileId());
            resultBean.setResponse(fileDTOList);
            return resultBean;
        } catch (Exception e) {
            logger.error("getKbsFileDetail  error req:{}, e:{}", JSON.toJSONString(homeSearchReq), e);
            return resultBean;
        }
    }

}
