package com.digiwin.athena.semc.controller.homepage.upgrade;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.dto.homepage.UpgradeInfoReminderDTO;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.homepage.IUpgradeInfoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoDetailResp;
import com.digiwin.athena.semc.vo.homepage.UpgradeInfoResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @description: 版更controller
 * @createDate: 2023/2/10 9:43
 * @author: sunyfa
 */
@Slf4j
@RestController
@RequestMapping("/semc/homepage/upgrade")
public class UpgradeInfoController {

    @Resource
    private IUpgradeInfoService upgradeInfoService;

    @Resource
    private MessageUtils messageUtils;

    @Resource
    private ICacheService cacheService;


    /**
     * @param
     * @return
     * @description: 红点/悬浮框查询
     * @author: sunyfa
     */
    @GetMapping("/reminder")
    public ResponseEntity<BaseResultDTO<List<UpgradeInfoReminderDTO>>> reminder(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(upgradeInfoService.getReminder());
        } catch (Exception e) {
            log.error("UpgradeInfoController reminder error", e);
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR,
                    messageUtils.getMessage(I18NKey.COMMON_SYSTEM_ERROR));
        }
    }

    /**
     * 重要升级提醒悬浮框关闭
     *
     * @param user 用户信息
     * @return 返回
     */
    @PostMapping("/closeImptReminder")
    public ResponseEntity<?> closeImptReminder(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user) {
        upgradeInfoService.closeImptReminder();
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 普通升级提醒悬浮框关闭
     *
     * @param user 用户信息
     * @return 返回
     */
    @PostMapping("/closeUpgradeReminder")
    public ResponseEntity<?> closeUpgradeReminder(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user) {
        upgradeInfoService.closeUpgradeReminder();
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 强提醒提醒悬浮框关闭
     *
     * @param user 用户信息
     * @return 返回
     */
    @PostMapping("/closeUpgradeStrongReminder")
    public ResponseEntity<?> closeUpgradeStrongReminder(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser user) {
        upgradeInfoService.closeUpgradeStrongReminder();
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 查询版更列表
     *
     * @return
     */
    @GetMapping("/list")
    public ResponseEntity<BaseResultDTO<List<UpgradeInfoResp>>> list() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(upgradeInfoService.queryUpgradeInfoList());
        } catch (Exception e) {
            log.error("UpgradeInfoController query upgrade info list error", e);
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, messageUtils.getMessage(I18NKey.COMMON_SYSTEM_ERROR));
        }
    }

    /**
     * 通过版更id查询版更详情
     *
     * @param id 版更id
     * @return
     */
    @GetMapping("/detail/{id}")
    public ResponseEntity<BaseResultDTO<UpgradeInfoDetailResp>> detail(@PathVariable("id") @NotEmpty(message = "版更id不能为空") String id) {
        try {
            UpgradeInfoDetailResp upgradeInfoDetailResp = upgradeInfoService.queryUpgradeDetail(id);
            return ResponseEntityWrapperUtil.wrapperOk(upgradeInfoDetailResp);
        } catch (Exception e) {
            log.error("UpgradeInfoController detail occur error, id:{}", id, e);
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, messageUtils.getMessage(I18NKey.COMMON_SYSTEM_ERROR));
        }
    }

    /**
     * @param key 版更id
     * @return
     * @description: 删除缓存
     * @author: sunyfa
     */
    @GetMapping("/deleteCache/{key}")
    public ResponseEntity<?> deleteCache(@PathVariable("key") @NotEmpty(message = "删除缓存的key不能为空") String key) {
        try {
            cacheService.delete(key);
            cacheService.deleteByPrex(key);
            return ResponseEntityWrapper.wrapperOk();
        } catch (Exception e) {
            log.error("UpgradeInfoController closeImptReminder error", e);
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR,
                    messageUtils.getMessage(I18NKey.COMMON_SYSTEM_ERROR));
        }
    }
}