package com.digiwin.athena.semc.controller.machine;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.entity.machine.UserCompanyFactory;
import com.digiwin.athena.semc.service.portal.CloudNavigationService;
import com.digiwin.athena.semc.entity.common.CompanyFactory;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/***
 * 移动端集成企业云导航
 */
@Slf4j
@RestController
@RequestMapping("/semc/cloudNavigation")
public class CloudNavigationController {

    private static final Logger logger = LoggerFactory.getLogger(CloudNavigationController.class);


    @Resource
    private CloudNavigationService cloudNavigationService;


    @Resource
    private MessageUtils messageUtils;


    /***
     * 获取所有公司别厂别
     */
    @PostMapping("/getCompanyFactoryList")
    public ResponseEntity<BaseResultDTO<List<UserCompanyFactory>>> getCompanyFactoryList(){
//        List<JSONObject> response =  cloudNavigationService.getCompanyFactoryList();
        List<UserCompanyFactory> response =  cloudNavigationService.getCompanyFactoryList2();
        return ResponseEntityWrapperUtil.wrapperOk(response);
    }



    /***
     * 保存公司别厂别
     * @param companyFactoryVO
     * @return
     */
    @PostMapping("/saveOrUpdateCompanyFactory")
    public ResponseEntity<?> saveOrUpdateCompanyOrFactory(@RequestBody CompanyFactory companyFactoryVO){
        if(!StringUtils.hasText(companyFactoryVO.getFactory()))
        {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_MISSING_ERROR, "公司别不可为空");
        }
        try {
            cloudNavigationService.saveOrUpdateCompanyOrFactory(companyFactoryVO);
        } catch (Exception e) {
            logger.error("/saveOrUpdateCompanyFactory exception", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/cloudNavigation/saveOrUpdateCompanyFactory");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

}
