package com.digiwin.athena.semc.controller.machine;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourcePreset;
import com.digiwin.athena.semc.service.machine.TopicPresetService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.machine.TopicPresetJobResp;
import com.digiwin.athena.semc.vo.machine.TopicPresetResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description 绿色智机
 * @author: dengkaiwen
 */
@RestController
@RequestMapping("/semc/topic/")
public class TopicPresetController {

    private static final Logger logger = LoggerFactory.getLogger(TopicPresetController.class);

    @Autowired
    TopicPresetService topicPresetService;

    @Resource
    private MessageUtils messageUtils;



    /**
     * 查询绿色智机项目权限接口
     * @return
     */
    @PostMapping("/queryUserAuth")
    public ResponseEntity<BaseResultDTO<TopicPresetResp>> queryUserAuth() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(topicPresetService.queryUserAuth());
        } catch (Exception e) {
            logger.error("queryUserAuth exception", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/topic/queryUserAuth");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }


    /**
     * 查询绿色智机模组作业接口
     * @return
     */
    @PostMapping("/job/queryAllJob")
    public ResponseEntity<BaseResultDTO<List<TopicPresetResp>>> queryAllJob(@RequestBody TopicPresetJobResp topicPresetJobResp) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(topicPresetService.queryAllJob(topicPresetJobResp.getCaseIdList()));
        } catch (Exception e) {
            logger.error("queryAllJob exception", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/topic/job/queryAllJob");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }



    /**
     * 绿色智机数据迁移到 移动应用/作业管理
     * @return
     */
    @PostMapping("/initPresetData")
    public ResponseEntity<BaseResultDTO<Integer>> initPresetData(@RequestBody MobileDatasourcePreset req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(topicPresetService.initPresetData(req.getTenantId()));
        } catch (Exception e) {
            logger.error("initPresetData exception", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/topic/job/queryAllJob");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

}
