package com.digiwin.athena.semc.controller.message;


import com.digiwin.athena.semc.dto.message.EmailCompanyMappingDeleteReq;
import com.digiwin.athena.semc.dto.message.EmailCompanyMappingReq;
import com.digiwin.athena.semc.dto.message.EmailCompanyMappingSaveOrUpdateReq;
import com.digiwin.athena.semc.service.portal.MessageEmailConfigService;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.*;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


import javax.annotation.Resource;
import javax.validation.Valid;



/**
 * @author CR-7
 * create: 2024-03-20 13:35
 * Description: 获取邮件未读数
 */
@Slf4j
@RestController
@RequestMapping("/semc/message/email")
public class MessageEmailController {


    @Resource
    MessageEmailConfigService messageEmailConfigService;


    /**
     * 查询智奇邮件配置列表
     * @return
     */
    @Operation(method = "listMailMessageConfig",description = "查询智奇邮件配置列表")
    @PostMapping("/listMailMessageConfig")
    public ResponseEntity<?> listMailMessageConfig(@RequestBody EmailCompanyMappingReq emailCompanyMappingReq) {
        return messageEmailConfigService.listMailMessageConfig(emailCompanyMappingReq);
    }


    /**
     * 新增或者编辑智奇邮件配置
     * @param emailCompanyMappingReq
     * @return
     */
    @Operation(method = "saveOrUpdate",description = "新增或者编辑智奇邮件配置")
    @PostMapping("/saveOrUpdate")
    public ResponseEntity<?> saveOrUpdate(@RequestBody @Valid EmailCompanyMappingSaveOrUpdateReq emailCompanyMappingReq) {
        return messageEmailConfigService.saveOrUpdate(emailCompanyMappingReq);
    }


    /**
     *  删除智奇邮件配置
     * @param deleteReq
     * @return
     */
    @Operation(method = "delete",description = "删除智奇邮件配置")
    @PostMapping("/delete")
    public ResponseEntity<?> delete(@RequestBody @Valid EmailCompanyMappingDeleteReq deleteReq) {
        return messageEmailConfigService.delete(deleteReq);
    }


    /**
     *  获取邮件未读数
     * @return
     */
    @Operation(method = "getUnreadCount",description = "获取邮件未读数")
    @PostMapping("/getUnreadCount")
    public ResponseEntity<?> getUnreadCount() {
        return messageEmailConfigService.getUnreadCount();
    }
}
