package com.digiwin.athena.semc.controller.mobile;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.service.mobile.MobileDataSourceAuthService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthListResp;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthQueryReq;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthSaveReq;
import io.swagger.v3.oas.annotations.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * @description 移动应用-作业权限控制
 * @author: dengkaiwen
 */
@RestController
@RequestMapping("/semc/mobile/datasource/auth/")
public class MobileDataSourceAuthController {

    private static final Logger logger = LoggerFactory.getLogger(MobileDataSourceAuthController.class);

    @Autowired
    MobileDataSourceAuthService mobileDataSourceAuthService;

    @Resource
    private MessageUtils messageUtils;

    /**
     * 查询移动应用-作业权限配置列表
     *
     * @param req 请求实体
     * @return
     * @throws Exception
     */
    @PostMapping("/queryAuthList")
    public  ResponseEntity<BaseResultDTO<List<MobileDataSourceAuthListResp>>>  queryAuthList(@RequestBody @Valid MobileDataSourceAuthQueryReq req) {
        try {
              return ResponseEntityWrapperUtil.wrapperOk(mobileDataSourceAuthService.queryAuthList(req));
        } catch (Exception e) {
            logger.error("queryAuthList exception", e);
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, messageUtils.getMessage(I18NKey.COMMON_SYSTEM_ERROR));
        }
    }


    /**
     * 保存移动应用-作业权限
     *
     * @param req 请求实体
     * @return
     * @throws Exception
     */
    @Operation(summary = "保存移动应用-作业权限")
    @PostMapping("/saveDatasourceAuth")
    public ResponseEntity<BaseResultDTO<Integer>> saveDatasourceAuth(@RequestBody @Valid MobileDataSourceAuthSaveReq req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(mobileDataSourceAuthService.saveDatasourceAuth(req));
        } catch (Exception e) {
            logger.error("saveDatasourceAuth exception", e);
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, messageUtils.getMessage(I18NKey.COMMON_SYSTEM_ERROR));
        }
    }

}
