package com.digiwin.athena.semc.controller.mobile;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.entity.mobile.MobileLabelSystemPre;
import com.digiwin.athena.semc.mapper.mobile.MobileLabelSystemPreMapper;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/semc/mobile/label")
public class MobileLabelSystemController {

    @Autowired
    private MobileLabelSystemPreMapper mobileLabelSystemPreMapper;

    /**
     * 保存系统预设组件
     * @param mobileLabelSystemPre
     * @return
     */
    @PostMapping("saveMobileLabelSystemPre")
    public ResponseEntity<BaseResultDTO<Integer>> saveSystemPre(@RequestBody MobileLabelSystemPre mobileLabelSystemPre){
        int insert = mobileLabelSystemPreMapper.insert(mobileLabelSystemPre);
        return ResponseEntityWrapperUtil.wrapperOk(insert);
    }
}
